/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.QueryTask;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

final class RecoveryThread
extends Thread {
    private static final String TRACE_MASKT = "XRBFRVTT";
    private static final String TRACE_MASKF = "XRBFRVTF";
    private static final String TRACE_MASKD = "XRBFRVTD";
    String id;
    private List requests;

    RecoveryThread(String id, List requests) {
        super("RBF Recovery Thread " + id);
        this.id = id;
        this.requests = requests;
        Trace.trace(TRACE_MASKT, "<> RecoveryThread() " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> Recovery " + this.id + " running");
        Trace.trace(TRACE_MASKF, "Recovering " + this.requests.size() + " requests");
        HandlerManager handlerMgr = HandlerManager.getHandlerManager();
        handlerMgr.waitUntilInitialized();
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            RequestTrackingData trackingData;
            RbfRequest request = (RbfRequest)iterator.next();
            RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
            synchronized (requestTrackingData) {
                Trace.trace(TRACE_MASKF, "Recovering: " + request.toDebugString());
                trackingData.addHistory("Recovering");
                if (!localMachine.equals(trackingData.origin)) {
                    trackingData.addHistory("Local machine now " + RbfUtils.getMachineInfo(localMachine));
                    MachineId oldLocalMachine = trackingData.origin;
                    trackingData.origin = localMachine;
                    if (trackingData.handlerSubset != null && trackingData.handlerSubset.remove(oldLocalMachine)) {
                        trackingData.handlerSubset.add(localMachine);
                    }
                    if (trackingData.removeUnusable(oldLocalMachine)) {
                        trackingData.addUnusable(localMachine);
                    }
                    if (oldLocalMachine.equals(trackingData.handler)) {
                        trackingData.setHandler(localMachine);
                    }
                }
                if (trackingData.state == 4) {
                    HandlerPreparer.prepareHandlers(request);
                } else if (trackingData.state == 8) {
                    if (localMachine.equals(trackingData.handler)) {
                        trackingData.handlerOutage = true;
                    }
                    if (trackingData.isHandlerNeeded()) {
                        HandlerPreparer.prepareHandlers(request);
                    } else {
                        QueryTask queryTask;
                        trackingData.queryTask = queryTask = new QueryTask(request.getIdentifier());
                        Timer queryTimer = QueryTask.getTimer();
                        queryTimer.schedule((TimerTask)queryTask, 0L, 300000L);
                    }
                } else if (trackingData.state != 12) {
                    if (trackingData.state == 16) {
                        ResultReporter.reportAndClose(request);
                    } else if (trackingData.state == 20) {
                        try {
                            RequestManager requestMgr = RequestManager.getRequestManager();
                            requestMgr.close(request);
                        }
                        catch (PersistenceNotInitializedException pnie) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- Recovery " + this.id + " ending");
    }
}

